import { system, world } from '@minecraft/server';
const bird_roster = {
	"sf_nba:bluejay": {},
	"sf_nba:budgie": {
		landingDistance: 7
	},
	"sf_nba:canary": {},
	"sf_nba:robin": {},
	"sf_nba:cardinal": {},
	"sf_nba:crow": {},
	"sf_nba:toucan": {},
	"sf_nba:owl": {},
	"sf_nba:raven": {},
	"sf_nba:sparrow": {},
	"sf_nba:finch": {},
	"sf_nba:eagle": { landingDistance: 8 }
};
const defaultLandingDistance = 5;
system.afterEvents.scriptEventReceive.subscribe(e => {
	const entity = e.sourceEntity;
	if (e.id == "sf_nba:bird_landing_check") {
		if (bird_roster[entity.typeId] == null) {
			world.sendMessage("Error: sf_nba:bird_landing_check can only be called from a bird mob.");
			return;
		}
		let landingDistance = bird_roster[entity.typeId].landingDistance ?? defaultLandingDistance;
		try {
			const block = entity.dimension.getBlockFromRay(entity.location, { x: 0, y: -landingDistance, z: 0 }, { includeLiquidBlocks: true })?.block;
			if ((block != null) && !block.isAir && !block.isLiquid) {
				entity.triggerEvent("sf_nba:bird_set_walking_mode")
			}
		}
		catch(err) {}
	}
})